package gov.va.med.mhv.usermgmt.bizobj;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.bizobj.BusinessObject;

import gov.va.med.mhv.core.util.DescriptionBuilder;
import gov.va.med.mhv.core.util.MessagesStringBuilder;
import gov.va.med.mhv.core.util.MessagesUtils;
import gov.va.med.mhv.core.util.Precondition;
//import gov.va.med.mhv.usermgmt.persist.CustomFacilityDao;
import gov.va.med.mhv.usermgmt.persist.DaoFactory;
import gov.va.med.mhv.usermgmt.util.PatientCorrelationStatusUtils;


/**
 * Business object for the Patient application entity
 *
 * Generated Skeleton Code
 */
 
public class PatientBO extends PatientBaseBO {
    
    private static final Log LOG = LogFactory.getLog(PatientBO.class);
    
    private static final Map<String, FacilityBO> EMPTY_MAP =
        Collections.unmodifiableMap(new HashMap<String, FacilityBO>());
    
	protected void complexValidation() {
	}

    protected void validateCorrelationStatus() {
        // NOTE Using the validation method to ensure the default value 
        // is being set (if the value is null). 
        // The base methods do not allo for this to be done in another way, 
        // such that this is the only good way to avoid distributing this 
        // code through the entire code base.
        if( getCorrelationStatus() == null ) {
            setCorrelationStatus(PatientCorrelationStatusUtils.UNCORRELATED);
        }
        super.validateCorrelationStatus();
    }

    public void save() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("save " + getUserName());
        }
        /*
        Map<String, FacilityBO> originalFacilities = mapOriginalFacilities();
        Map<String, FacilityBO> newFacilities = mapNewFacilities();
        if (getId() != null) {
            // Controls must sever references to the facilities that removed
            // This must happen before the actual save, due to a foreign key 
            // constraint. We do NOT want a cascading delete, because the 
            // disabled FacilityControl will mark all associated PHR records
            // as deleted.
            // NOTE That this constraint is not generated by Atlas builds
            disableFacilityControls(originalFacilities, newFacilities);
            if (hasErrorMessages()) {
                return;
            }
        }
        */
        super.save();
        if (hasErrorMessages()) {
            return;
        }

        // Controls must be created for any new facility 
        // This must happen after the actual save, due to a foreign key 
        // constraint. The new facilities do not exist in the database
        // before the save.
        /*
        createFacilityControls(originalFacilities, newFacilities);
        */
    }

    public void delete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("delete " + getUserName());
        }
        /*
        disableFacilityControls(mapOriginalFacilities(), EMPTY_MAP);
        if (hasErrorMessages()) {
            return;
        }
        */
        super.delete();
    }
    
    protected boolean hasErrorMessages() {
        return MessagesUtils.hasErrorMessage(getAllMessages());
    }

    protected void copyMessages(BusinessObject bo) {
        Precondition.assertNotNull("bo", bo);
        getMessages().addMessages(bo.getAllMessages());
    }

    protected void logErrorMessages(String action) {
        LOG.error("A problem occurred while " + action + ", because " + 
            new MessagesStringBuilder().append(getAllMessages(), 
                PatientBO.class).toString());
    }

    private String getUserName() {
        return getUserName(this);
    }
    
    private String getUserName(PatientBO patient) {
        if ((patient == null) || (patient.getUserProfile() == null)) {
            return "unknown patient";
        }
        return "patient '" + patient.getUserProfile().getUserName() + "'";
    }

}